% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparrowResult-methods.R
\name{resultNames}
\alias{resultNames}
\alias{result}
\alias{result.SparrowResult}
\alias{results}
\alias{tabulateResults}
\title{Interrogate the results of a sparrow::seas analysis stored in a SparrowResult}
\usage{
resultNames(x)

result(x, ...)

\method{result}{SparrowResult}(
  x,
  name = NULL,
  stats.only = FALSE,
  rank.by = c("pval", "t", "logFC"),
  add.suffix = FALSE,
  as.dt = FALSE,
  ...
)

results(
  x,
  names = resultNames(x),
  stats.only = TRUE,
  rank.by = c("pval", "logFC", "t"),
  add.suffix = length(names) > 1L,
  as.dt = FALSE
)

tabulateResults(
  x,
  names = resultNames(x),
  max.p = 0.2,
  p.col = c("padj", "padj.by.collection", "pval"),
  as.dt = FALSE
)
}
\arguments{
\item{x}{A \code{\link[=SparrowResult]{SparrowResult()}} object.}

\item{...}{pass through arguments}

\item{name}{the names of the results desired}

\item{stats.only}{logical, set to \code{FALSE} if you want to return all
(column-wise) data for each result. By default only the pvalues,
adjusted pvalues, and rank are returned.}

\item{rank.by}{the statistic to use to append a \code{rank} column for the
geneset result. By default we rank by pvalue calculated by the GSEA
method. You can rank the results based on the trimmed mean of the logFC's
calculated for all of the features in the geneset (\code{"logFC"}), or the
trimmed t-statistics of the these features (\code{"t"}).}

\item{add.suffix}{If \code{TRUE}, adds \code{.name} as a suffix to the
columns of the \code{method}-specific statistics returned, ie. the
\code{pval} column from the \code{"camera"} result will be turned to
\code{pval.camera}.}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}

\item{names}{the names of the GSEA methods to be reported. By default,
this function will display results for all methods.}

\item{max.p}{The maximum padj value to consider a result significant}

\item{p.col}{use padj or padj.by.collection?}
}
\value{
a data.table with the results from the requested method.

a data.table that summarizes the significant results per method
per collection for the GSEA that was run
}
\description{
The \code{resultNames}, \code{result}, and \code{results} functions enable
you to explore the results of the analysis run with \code{\link[=seas]{seas()}}.

The results that are stored within a \code{SparrowResult} object have a
more or less 1:1 mapping with the values passed as \code{methods}, parameter
of the \code{\link[=seas]{seas()}} call.

Generates a table to indicate the number of genesets per collection that
pass a given FDR. The table provides separate groups of rows for each of
the \code{methods} run in the \code{\link[=seas]{seas()}} call that generated that
generated \code{x}.
}
\details{
The product of an indivdual GSEA is consumed by the corresponding
\verb{do.<METHOD>} function and converted into a data.table of results that
is internally stored.

Use the \code{resultNames()} function to identify which results are available
for interrogation. The \code{result()} function returns the statistics of
one individual result, and the \code{results()} function combines the results
from the specified methods into an arbitrarily wide data.table with
\code{method}-suffixed column names.

Use the \code{tabulateResults()} function to create a summary table that
tallies the number of significant genesets per collection, per method at
the specified FDR thresholds.
}
\examples{
res <- exampleSparrowResult()
resultNames(res)
head(result(res, "camera"))
head(results(res))
}
