% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_RCTD.R
\name{createRctdConfig}
\alias{createRctdConfig}
\title{Create RCTD configuration object}
\usage{
createRctdConfig(
  rctd_data,
  max_cores = 1,
  max_multi_types = 4,
  confidence_threshold = 5,
  doublet_threshold = 20
)
}
\arguments{
\item{rctd_data}{list containing \code{\link{createRctd}} output}

\item{max_cores}{numeric, maximum number of cores to use for parallel
processing (default: 4)}

\item{max_multi_types}{numeric, maximum number of cell types per pixel in
multi mode (default: 4)}

\item{confidence_threshold}{numeric, minimum change in likelihood (compared
to other cell types) necessary to determine a cell type identity with
confidence (default: 5)}

\item{doublet_threshold}{numeric, penalty weight of predicting a doublet
instead of a singlet for a pixel (default: 20)}
}
\value{
RCTD configuration
}
\description{
Used internally by \code{\link{runRctd}}.
}
\details{
Default value of max_cores is set to 1 so that devtools::check() does not
complain about parallelism in examples.
}
\examples{
data(rctdSim)

# Spatial transcriptomics data
library(SpatialExperiment)
spatial_spe <- SpatialExperiment(
    assay = rctdSim$spatial_rna_counts,
    spatialCoords = rctdSim$spatial_rna_coords
)

# Reference data
library(SummarizedExperiment)
reference_se <- SummarizedExperiment(
    assays = list(counts = rctdSim$reference_counts),
    colData = rctdSim$reference_cell_types
)

# Create RCTD configuration
rctd_data <- createRctd(spatial_spe, reference_se)
rctd <- createRctdConfig(rctd_data)
rctd <- fitBulk(rctd)
rctd <- chooseSigmaC(rctd)
results <- fitPixels(rctd, rctd_mode = "doublet")

}
\keyword{internal}
