% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNuclei.R
\name{addNuclei}
\alias{addNuclei}
\title{Add nuclei to a hyperframe}
\usage{
addNuclei(
  hypFrame,
  nucleiList,
  checkSubset = TRUE,
  verbose = TRUE,
  coords = c("x", "y"),
  overwriteNuclei = FALSE,
  ...
)
}
\arguments{
\item{hypFrame}{A hyperframe}

\item{nucleiList}{A list containing a list of owins per point pattern.
The length of the list must match the length of the hyperframe, and the names must match.
Also lists of geojson objects, coordinate matrices or rois are accepted, see \link{addCell}}

\item{checkSubset}{A boolean, should be checked whether nuclei are encompassed by cells?}

\item{verbose}{A boolean, should verbose output be printed?}

\item{coords}{The names of the coordinates, if the nuclei are given as sets of coordinates.}

\item{overwriteNuclei}{A boolean, should existing nuclei be replaced?}

\item{...}{Further arguments passed onto \link{convertToOwins}}
}
\value{
The hyperframe with nuclei added as entry
}
\description{
Add the nuclei identifiers to a hyperframe already containing cells.
}
\details{
The nuclei names must match the cell names already present, all other nuclei are dropped. 
A warning is issued when nuclei are not encompassed by their cell.
}
\examples{
library(spatstat.random)
set.seed(54321)
n <- 1e3 # number of molecules
ng <- 25 # number of genes
nfov <- 3 # Number of fields of view
conditions <- 3
# sample xy-coordinates in [0, 1]
x <- runif(n)
y <- runif(n)
# assign each molecule to some gene-cell pair
gs <- paste0("gene", seq(ng))
gene <- sample(gs, n, TRUE)
fov <- sample(nfov, n, TRUE)
condition <- sample(conditions, n, TRUE)
# construct data.frame of molecule coordinates
df <- data.frame(gene, x, y, fov, "condition" = condition)
# A list of point patterns
listPPP <- tapply(seq(nrow(df)), df$fov, function(i) {
    ppp(x = df$x[i], y = df$y[i], marks = df[i, "gene", drop = FALSE])
}, simplify = FALSE)
# Regions of interest (roi): Diamond in the center plus four triangles
w1 <- owin(poly = list(x = c(0, .5, 1, .5), y = c(.5, 0, .5, 1)))
w2 <- owin(poly = list(x = c(0, 0, .5), y = c(.5, 0, 0)))
w3 <- owin(poly = list(x = c(0, 0, .5), y = c(1, 0.5, 1)))
w4 <- owin(poly = list(x = c(1, 1, .5), y = c(0.5, 1, 1)))
w5 <- owin(poly = list(x = c(1, 1, .5), y = c(0, 0.5, 0)))
hypFrame <- buildHyperFrame(df,
    coordVars = c("x", "y"),
    imageVars = c("condition", "fov")
)
nDesignFactors <- length(unique(hypFrame$image))
wList <- lapply(seq_len(nDesignFactors), function(x) {
    list("w1" = w1, "w2" = w2, "w3" = w3, "w4" = w4, "w5" = w5)
})
names(wList) <- rownames(hypFrame) # Matching names is necessary
hypFrame2 <- addCell(hypFrame, wList)
# The nuclei
n1 <- owin(poly = list(x = c(0.2, .4, 0.8, .4), y = c(.4, .2, .4, .8)))
n2 <- owin(poly = list(x = c(0.1, 0.1, .4), y = c(.4, .1, .1)))
n3 <- owin(poly = list(x = c(0.1, 0.1, .4), y = c(1, .75, 1)))
n4 <- owin(poly = list(x = c(1, 1, .6), y = c(.7, .9, .9)))
n5 <- owin(poly = list(x = c(.95, .95, .7), y = c(.1, .4, .1)))
nList <- lapply(seq_len(nDesignFactors), function(x) {
    list("w1" = n1, "w2" = n2, "w3" = n3, "w4" = n4, "w5" = n5)
})
names(nList) <- rownames(hypFrame) # Matching names is necessary
hypFrame3 <- addNuclei(hypFrame2, nList)
}
\seealso{
\link{addCell}, \link{convertToOwins}
}
