% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_markers.R
\name{top_markers_glm}
\alias{top_markers_glm}
\title{calculate group mean score using glm and order genes based on scores difference}
\usage{
top_markers_glm(
  data,
  label,
  n = 10,
  family = gaussian(),
  batch = NULL,
  scale = TRUE,
  use.mgm = TRUE,
  pooled.sd = FALSE,
  softmax = TRUE,
  tau = 1
)
}
\arguments{
\item{data}{matrix, features in row and samples in column}

\item{label}{a vector of group label}

\item{n}{integer, number of returned top genes for each group}

\item{family}{family for glm, details in \code{\link[stats:glm]{stats::glm()}}}

\item{batch}{a vector of batch labels, default NULL}

\item{scale}{logical, if to scale data by row}

\item{use.mgm}{logical, if to scale data using \code{\link[=scale_mgm]{scale_mgm()}}}

\item{pooled.sd}{logical, if to use pooled SD for scaling}

\item{softmax}{logical, if to apply softmax transformation on output}

\item{tau}{numeric, hyper parameter for softmax}
}
\value{
a tibble with feature names, group labels and ordered processed scores
}
\description{
calculate group mean score using glm and order genes based on scores difference
}
\examples{
data <- matrix(rgamma(100, 2), 10, dimnames = list(1:10))
top_markers_glm(data, label = rep(c("A", "B"), 5))
}
