% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/top_markers-methods.R
\name{top_markers}
\alias{top_markers}
\alias{top_markers,AnyMatrix-method}
\alias{top_markers,SummarizedExperiment-method}
\title{scale score and return top markers}
\usage{
top_markers(
  data,
  label,
  n = 10,
  use.glm = TRUE,
  batch = NULL,
  scale = TRUE,
  use.mgm = TRUE,
  softmax = TRUE,
  slot = "score",
  ...
)

\S4method{top_markers}{AnyMatrix}(
  data,
  label,
  n = 10,
  use.glm = TRUE,
  batch = NULL,
  scale = TRUE,
  use.mgm = TRUE,
  softmax = TRUE,
  slot = "score",
  ...
)

\S4method{top_markers}{SummarizedExperiment}(
  data,
  label,
  n = 10,
  use.glm = TRUE,
  batch = NULL,
  scale = TRUE,
  use.mgm = TRUE,
  softmax = TRUE,
  slot = "score",
  ...
)
}
\arguments{
\item{data}{an expression object, can be matrix or SummarizedExperiment}

\item{label}{a vector of group label}

\item{n}{integer, number of returned top genes for each group}

\item{use.glm}{logical, if to use \code{\link[stats:glm]{stats::glm()}} to compute group mean score,
if TRUE, also compute mean score difference as output}

\item{batch}{a vector of batch labels, default NULL}

\item{scale}{logical, if to scale data by row}

\item{use.mgm}{logical, if to scale data using \code{\link[=scale_mgm]{scale_mgm()}}}

\item{softmax}{logical, if to apply softmax transformation on output}

\item{slot}{a character, specify which slot to use when data is se object,
optional, default 'score'}

\item{...}{params for \code{\link[=top_markers_abs]{top_markers_abs()}} or \code{\link[=top_markers_glm]{top_markers_glm()}}}
}
\value{
A tibble with top n feature names, group labels and ordered scores
}
\description{
scale and transform score and output top markers for groups
}
\examples{
data <- matrix(rgamma(100, 2), 10, dimnames = list(1:10))
top_markers(data, label = rep(c("A", "B"), 5))
}
