% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_mgm.R
\name{scale_mgm}
\alias{scale_mgm}
\title{scale by mean of group mean for imbalanced data}
\usage{
scale_mgm(expr, label, pooled.sd = FALSE)
}
\arguments{
\item{expr}{matrix}

\item{label}{a vector of group label}

\item{pooled.sd}{logical, if to use pooled SD for scaling}
}
\value{
scaled matrix
}
\description{
scale by mean of group mean for imbalanced data
}
\details{
\deqn{z=\frac{x-\frac{\sum_k^{n_D}(\mu_k)}{n_D}}{s}}
where \eqn{\mu_k} is the mean of x in \eqn{k^{th}} class, and \eqn{n_D} is
the number of classes, \eqn{s} is the standard deviation of x,
when \code{pooled.sd} is set to be TRUE, \eqn{s} will be replaced with
\eqn{s_{pooled}}, \eqn{s_{pooled}=\sqrt{\frac{\sum_k^{n_D}{(n_k-1){s_k}^2}}{\sum_k^{n_D}{n_k}-k}}}
}
\examples{
scale_mgm(matrix(rnorm(100), 10), label = rep(letters[1:2], 5))
}
