% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{idf}
\alias{idf}
\title{standard inverse cell frequency}
\usage{
idf(expr, features = NULL, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a vector of inverse cell frequency score for each feature
}
\description{
standard inverse cell frequency
}
\details{
\deqn{\mathbf{IDF_i} = log(1+\frac{n}{n_i+1})}
where \eqn{n} is the total number of cells, \eqn{n_i} is the number of cells
containing feature i.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::idf(data)
}
