% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/gs_score-methods.R
\name{gs_score}
\alias{gs_score}
\alias{gs_score,AnyMatrix,ANY-method}
\alias{gs_score,AnyMatrix,list-method}
\alias{gs_score,SummarizedExperiment,ANY-method}
\title{compute overall score based on the given marker list}
\usage{
gs_score(data, features = NULL, slot = "score", suffix = "score")

\S4method{gs_score}{AnyMatrix,ANY}(data, features = NULL)

\S4method{gs_score}{AnyMatrix,list}(data, features = NULL, suffix = "score")

\S4method{gs_score}{SummarizedExperiment,ANY}(data, features = NULL, slot = "score", suffix = "score")
}
\arguments{
\item{data}{an expression object, can be matrix or SummarizedExperiment}

\item{features}{vector or named list, feature names to compute score}

\item{slot}{a character, specify which slot to use when data is se object,
optional, default 'score'}

\item{suffix}{a character, specify the name suffix to save score when
features is a named list}
}
\value{
A vector of overall score for each sample
}
\description{
compute overall score based on the given marker list
}
\examples{
data <- matrix(rnorm(100), 10, dimnames = list(seq_len(10)))
gs_score(data, features = seq_len(3))
}
