% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{cal_score_init}
\alias{cal_score_init}
\title{Calculate score for each feature in each cell}
\usage{
cal_score_init(
  expr,
  tf = c("logtf", "tf"),
  idf = "prob",
  iae = "prob",
  par.idf = NULL,
  par.iae = NULL
)
}
\arguments{
\item{expr}{a count matrix, features in row and cells in column}

\item{tf}{a character, specify the TF method to use, can be "tf" or "logtf"}

\item{idf}{a character, specify the IDF method to use. Available methods can
be accessed using \code{\link[=idf_iae_methods]{idf_iae_methods()}}}

\item{iae}{a character, specify the IAE method to use. Available methods can
be accessed using \code{\link[=idf_iae_methods]{idf_iae_methods()}}}

\item{par.idf}{other parameters for specified IDF methods}

\item{par.iae}{other parameters for specified IAE methods}
}
\value{
a list of combined score, tf, idf and iae
}
\description{
Calculate score for each feature in each cell
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
label <- sample(c("A", "B"), 10, replace = TRUE)
smartid:::cal_score_init(data,
  par.idf = list(label = label),
  par.iae = list(label = label)
)
}
