% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importAlevin.R
\name{importAlevin}
\alias{importAlevin}
\title{Construct SCE object from Salmon-Alevin output}
\usage{
importAlevin(
  alevinDir = NULL,
  sampleName = "sample",
  delayedArray = FALSE,
  class = c("Matrix", "matrix"),
  rowNamesDedup = TRUE
)
}
\arguments{
\item{alevinDir}{Character. The output directory of salmon-Alevin pipeline.
It should contain subfolder named 'alevin', which contains the count data
which is stored
in 'quants_mat.gz'. Default \code{NULL}.}

\item{sampleName}{Character. A user-defined sample name for the sample to be
imported. The 'sampleName' will be appended to the begining of cell
barcodes. Default is 'sample'.}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{FALSE}.}

\item{class}{Character. The class of the expression matrix stored in the SCE
object. Can be one of "Matrix" (as returned by
\link{readMM} function), or "matrix" (as returned by
\link[base]{matrix} function). Default "Matrix".}

\item{rowNamesDedup}{Boolean. Whether to deduplicate rownames. Default 
\code{TRUE}.}
}
\value{
A \code{SingleCellExperiment} object containing the count
 matrix, the feature annotations, and the cell annotation
 (which includes QC metrics stored in 'featureDump.txt').
}
\description{
Construct SCE object from Salmon-Alevin output
}
