% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDimRed.R
\name{plotDimRed}
\alias{plotDimRed}
\title{Plot dimensionality reduction from computed metrics including PCA, ICA, tSNE
and UMAP}
\usage{
plotDimRed(
  inSCE,
  useReduction = "PCA",
  showLegend = FALSE,
  xDim = 1,
  yDim = 2,
  xAxisLabel = NULL,
  yAxisLabel = NULL
)
}
\arguments{
\item{inSCE}{Input SCE object}

\item{useReduction}{Reduction to plot. Default is \code{"PCA"}.}

\item{showLegend}{If legends should be plotted or not}

\item{xDim}{Numeric value indicating the dimension to use for X-axis.
Default is 1 (refers to PC1).}

\item{yDim}{Numeric value indicating the dimension to use for Y-axis.
Default is 2 (refers to PC2).}

\item{xAxisLabel}{Specify the label for x-axis. Default is \code{NULL} which
will specify the label as 'x'.}

\item{yAxisLabel}{Specify the label for y-axis. Default is \code{NULL} which
will specify the label as 'y'.}
}
\value{
plot object
}
\description{
Plot dimensionality reduction from computed metrics including PCA, ICA, tSNE
and UMAP
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
plotDimRed(mouseBrainSubsetSCE, "PCA_logcounts")
}
