% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDEAnalysis.R
\name{plotDEGViolin}
\alias{plotDEGViolin}
\title{Generate violin plot to show the expression of top DEGs}
\usage{
plotDEGViolin(
  inSCE,
  useResult,
  threshP = FALSE,
  labelBy = NULL,
  nrow = 6,
  ncol = 6,
  defaultTheme = TRUE,
  isLogged = TRUE,
  check_sanity = TRUE
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{useResult}{character. A string specifying the \code{analysisName}
used when running a differential expression analysis function.}

\item{threshP}{logical. Whether to plot threshold values from adaptive
thresholding, instead of using the assay used by \code{runMAST()}. Default
\code{FALSE}.}

\item{labelBy}{A single character for a column of \code{rowData(inSCE)} as
where to search for the labeling text. Default \code{NULL}.}

\item{nrow}{Integer. Number of rows in the plot grid. Default \code{6}.}

\item{ncol}{Integer. Number of columns in the plot grid. Default \code{6}.}

\item{defaultTheme}{Logical scalar. Whether to use default SCTK theme in
ggplot. Default \code{TRUE}.}

\item{isLogged}{Logical scalar. Whether the assay used for the analysis is
logged. If not, will do a \code{log(assay + 1)} transformation. Default
\code{TRUE}.}

\item{check_sanity}{Logical scalar. Whether to perform MAST's sanity check
to see if the counts are logged. Default \code{TRUE}}
}
\value{
A ggplot object of violin plot
}
\description{
Generate violin plot to show the expression of top DEGs
}
\details{
Any of the differential expression analysis method from SCTK should
be performed prior to using this function
}
\examples{
data("sceBatches")
logcounts(sceBatches) <- log1p(counts(sceBatches))
sce.w <- subsetSCECols(sceBatches, colData = "batch == 'w'")
sce.w <- runWilcox(sce.w, class = "cell_type",
                   classGroup1 = "alpha", classGroup2 = "beta",
                   groupName1 = "w.alpha", groupName2 = "w.beta",
                   analysisName = "w.aVSb")
plotDEGViolin(sce.w, "w.aVSb")
}
