% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownsampleMatrix.R
\name{iterateSimulations}
\alias{iterateSimulations}
\title{Returns significance data from a snapshot.}
\usage{
iterateSimulations(
  originalData,
  useAssay = "counts",
  realLabels,
  totalReads,
  cells,
  iterations
)
}
\arguments{
\item{originalData}{The \linkS4class{SingleCellExperiment} object storing all
assay data from the shiny app.}

\item{useAssay}{Character. The name of the assay to be used for subsampling.}

\item{realLabels}{Character. The name of the condition of interest. Must match
a name from sample data.}

\item{totalReads}{Numeric. The total number of reads in the simulated
dataset, to be split between all simulated cells.}

\item{cells}{Numeric. The number of virtual cells to simulate.}

\item{iterations}{Numeric. How many times should each experimental design be
simulated.}
}
\value{
A matrix of significance information from a snapshot
}
\description{
Returns significance data from a snapshot.
}
\examples{
data("mouseBrainSubsetSCE")
res <- iterateSimulations(mouseBrainSubsetSCE, realLabels = "level1class",
                          totalReads = 1000, cells = 10, iterations = 2)

}
