% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSTARSolo.R
\name{importSTARsolo}
\alias{importSTARsolo}
\title{Construct SCE object from STARsolo outputs}
\usage{
importSTARsolo(
  STARsoloDirs,
  samples,
  STARsoloOuts = c("Gene", "GeneFull"),
  matrixFileNames = "matrix.mtx",
  featuresFileNames = "features.tsv",
  barcodesFileNames = "barcodes.tsv",
  gzipped = "auto",
  class = c("Matrix", "matrix"),
  delayedArray = FALSE,
  rowNamesDedup = TRUE
)
}
\arguments{
\item{STARsoloDirs}{A vector of root directories of STARsolo output files.
The paths should be something like this:
\bold{/PATH/TO/\emph{prefix}Solo.out}. For example: \code{./Solo.out}.
Each sample should have its own path. Must have the same length as
\code{samples}.}

\item{samples}{A vector of user-defined sample names for the sample to be
imported. Must have the same length as \code{STARsoloDirs}.}

\item{STARsoloOuts}{Character. The intermediate
folder to filtered or raw cell barcode, feature, and matrix files
for each of \code{samples}. Default \code{"Gene"}.
It can be either Gene or GeneFull as the main folder from
which data needs to be imported.}

\item{matrixFileNames}{Filenames for the Market Exchange Format (MEX) sparse
matrix file (.mtx file). Must have length 1 or the same
length as \code{samples}.}

\item{featuresFileNames}{Filenames for the feature annotation file.
Must have length 1 or the same
length as \code{samples}.}

\item{barcodesFileNames}{Filenames for the cell barcode list file.
Must have length 1 or the same
length as \code{samples}.}

\item{gzipped}{Boolean. \code{TRUE} if the STARsolo output files
(barcodes.tsv, features.tsv, and matrix.mtx) were
gzip compressed. \code{FALSE} otherwise. This is \code{FALSE} in STAR
2.7.3a. Default \code{"auto"} which automatically detects if the
files are gzip compressed. Must have length 1 or the same
length as \code{samples}.}

\item{class}{Character. The class of the expression matrix stored in the SCE
object. Can be one of "Matrix" (as returned by
\link{readMM} function), or "matrix" (as returned by
\link[base]{matrix} function). Default "Matrix".}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{FALSE}.}

\item{rowNamesDedup}{Boolean. Whether to deduplicate rownames. Default
\code{TRUE}.}
}
\value{
A \code{SingleCellExperiment} object containing the count
 matrix, the gene annotation, and the cell annotation.
}
\description{
Read the barcodes, features (genes), and matrices from STARsolo
 outputs. Import them
 as one \link[SingleCellExperiment]{SingleCellExperiment} object.
}
\examples{
# Example #1
# FASTQ files were downloaded from
# https://support.10xgenomics.com/single-cell-gene-expression/datasets/3.0.0
# /pbmc_1k_v3
# They were concatenated as follows:
# cat pbmc_1k_v3_S1_L001_R1_001.fastq.gz pbmc_1k_v3_S1_L002_R1_001.fastq.gz >
# pbmc_1k_v3_R1.fastq.gz
# cat pbmc_1k_v3_S1_L001_R2_001.fastq.gz pbmc_1k_v3_S1_L002_R2_001.fastq.gz >
# pbmc_1k_v3_R2.fastq.gz
# The following STARsolo command generates the filtered feature, cell, and
# matrix files
# STAR \
#   --genomeDir ./index \
#   --readFilesIn ./pbmc_1k_v3_R2.fastq.gz \
#                 ./pbmc_1k_v3_R1.fastq.gz \
#   --readFilesCommand zcat \
#   --outSAMtype BAM Unsorted \
#   --outBAMcompression -1 \
#   --soloType CB_UMI_Simple \
#   --soloCBwhitelist ./737K-august-2016.txt \
#   --soloUMIlen 12

# The top 20 genes and the first 20 cells are included in this example.
sce <- importSTARsolo(
  STARsoloDirs = system.file("extdata/STARsolo_PBMC_1k_v3_20x20",
    package = "singleCellTK"),
  samples = "PBMC_1k_v3_20x20")
}
