% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkQCUtils.R
\name{generateMeta}
\alias{generateMeta}
\title{Generate HTAN manifest file for droplet and cell count data}
\usage{
generateMeta(
  dropletSCE = NULL,
  cellSCE = NULL,
  samplename,
  dir,
  HTAN = TRUE,
  dataType = c("Droplet", "Cell", "Both")
)
}
\arguments{
\item{dropletSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
droplet count matrix data}

\item{cellSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
cell count matrix data}

\item{samplename}{The sample name of the \link[SingleCellExperiment]{SingleCellExperiment} objects}

\item{dir}{The output directory of the SCTK QC pipeline.}

\item{HTAN}{Whether generates manifest file including HTAN specific ID (HTAN Biospecimen ID, 
HTAN parent file ID and HTAN patient ID). Default is TRUE.}

\item{dataType}{Type of the input data. It can be one of "Droplet", "Cell" or "Both".}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object which combines all
objects in sceList. The colData is merged.
}
\description{
Generate HTAN manifest file for droplet and cell count data
}
