% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownsampleMatrix.R
\name{downSampleCells}
\alias{downSampleCells}
\title{Estimate numbers of detected genes, significantly differentially expressed
genes, and median significant effect size}
\usage{
downSampleCells(
  originalData,
  useAssay = "counts",
  minCountDetec = 10,
  minCellsDetec = 3,
  minCellnum = 10,
  maxCellnum = 1000,
  realLabels,
  depthResolution = 10,
  iterations = 10,
  totalReads = 1e+06
)
}
\arguments{
\item{originalData}{The \linkS4class{SingleCellExperiment} object storing all
assay data from the shiny app.}

\item{useAssay}{Character. The name of the assay to be used for subsampling.}

\item{minCountDetec}{Numeric. The minimum number of reads found for a gene to
be considered detected.}

\item{minCellsDetec}{Numeric. The minimum number of cells a gene must have at
least 1 read in for it to be considered detected.}

\item{minCellnum}{Numeric. The minimum number of virtual cells to include in
the smallest simulated dataset.}

\item{maxCellnum}{Numeric. The maximum number of virtual cells to include in
the largest simulated dataset}

\item{realLabels}{Character. The name of the condition of interest. Must match
a name from sample data. If only two factors present in the corresponding
colData, will default to t-test. If multiple factors, will default to ANOVA.}

\item{depthResolution}{Numeric. How many different read depth should the
script simulate? Will simulate a number of experimental designs ranging from
10 reads to maxReadDepth, with logarithmic spacing.}

\item{iterations}{Numeric. How many times should each experimental design be
simulated?}

\item{totalReads}{Numeric. How many aligned reads to put in each simulated
dataset.}
}
\value{
A 3-dimensional array, with dimensions = c(iterations,
depthResolution, 3). [,,1] contains the number of detected genes in each
simulated dataset, [,,2] contains the number of significantly differentially
expressed genes in each simulation, and [,,3] contains the mediansignificant
effect size in each simulation. If no genes are significantly differentially
expressed, the median effect size defaults to infinity.
}
\description{
Estimate numbers of detected genes, significantly differentially expressed
genes, and median significant effect size
}
\examples{
data("mouseBrainSubsetSCE")
subset <- mouseBrainSubsetSCE[seq(100),]
res <- downSampleCells(subset,
                       realLabels = "level1class",
                       iterations=2)
}
