% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{shortest_distances_via_NCA}
\alias{shortest_distances_via_NCA}
\alias{longest_distances_via_LCA}
\alias{shortest_distances_directed}
\alias{longest_distances_directed}
\title{Distance on the DAG}
\usage{
shortest_distances_via_NCA(dag, terms, verbose = simona_opt$verbose)

longest_distances_via_LCA(dag, terms, verbose = simona_opt$verbose)

shortest_distances_directed(dag, terms, verbose = simona_opt$verbose)

longest_distances_directed(dag, terms, verbose = simona_opt$verbose)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names.}

\item{verbose}{Whether to print messages.}
}
\value{
A numeric distance matrix.
}
\description{
Distance on the DAG
}
\details{
Denote two terms as \code{a} and \code{b}, a common ancestor as \code{c}, and the distance function \code{d()} calculates the longest
distance or the shortest distance depending on the function.
\itemize{
\item \code{shortest_distances_via_NCA()}: It calculates the smallest \code{d(c, a) + d(c, b)} where \code{d()} calculates the shortest distance between two terms. In this case,
\code{c} is the NCA (nearest common ancestor) of \code{a} and \code{b}.
\item \code{longest_distances_via_LCA()}: It calculates the largest \code{d(c, a) + d(c, b)} where \code{d()} calculates the longest distance between two terms \emph{via the LCA (lowest common ancestor) term}. In this case,
\code{c} is the LCA of \code{a} and \code{b}.
\item \code{shortest_distances_directed()}: It calculates \code{d(a, b)} where \code{d()} calculates the shortest distance between two terms. The distance is only calculated when \code{a} is an ancestor of \code{b}, otherwise the distance value is -1.
\item \code{longest_distances_directed()}: It calculates \code{d(a, b)} where \code{d()} calculates the longest distance between two terms. The distance is only calculated when \code{a} is an ancestor of \code{b}, otherwise the distance value is -1.
}
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
shortest_distances_via_NCA(dag, letters[1:6])
longest_distances_via_LCA(dag, letters[1:6])
shortest_distances_directed(dag, letters[1:6])
longest_distances_directed(dag, letters[1:6])
}
