% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{survivalSignPlot}
\alias{survivalSignPlot}
\title{Survival Plot}
\usage{
survivalSignPlot(
  data,
  survData,
  whichSign,
  cutpoint = "mean",
  sampleAnnot = NULL,
  selectByAnnot = NULL
)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{survData}{a dataframe with samples on rows and two columns. The first
column holds survival data of time, indicating the follow up times; the
second holds data of the survival status, normally 0=alive and 1=dead. For
further details check \code{\link[survival]{Surv}} function.}

\item{whichSign}{character string saying the signature to plot. This must
be a signature computed with signifinder.}

\item{cutpoint}{a character string (one of: "median", "mean" and "optimal")
or a numeric value, which divide samples between high scores and low scores.
The function computes the threshold with the method indicated or employs the
values directly supplied by the user. Based on that number, it divides
samples. In case of "optimal" the \code{\link[maxstat]{maxstat.test}}
function will be used to estimate the cutpoint which separates samples best.}

\item{sampleAnnot}{a categorical vector containing samples' annotations
named with samples names equal to the row names used in `survData`.}

\item{selectByAnnot}{character string saying the subgroup from `sampleAnnot`
used to compute the survival analysis.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Given a signature and samples' survival data, the function plots survival
curves for that signature. This is a wrapper around
\code{\link[survival]{survfit}}, that creates survival curves from a model
formula. Here, the response variable in the formula is a survival object
created by \code{\link[survival]{Surv}}. Survival curves are then passed to
the \code{\link[survminer]{ggsurvplot}} function.
For details about the statistics see
\code{\link[survival]{survfit}} and \code{\link[survival]{Surv}}.
}
\examples{
data(ovse)
mysurvData <- cbind(ovse$os, ovse$status)
rownames(mysurvData) <- rownames(SummarizedExperiment::colData(ovse))
survivalSignPlot(
    data = ovse,
    survData = mysurvData,
    whichSign = "Ferroptosis_Ye"
)

}
