% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-misc.R
\name{upload_init}
\alias{upload_init}
\title{Initializes the upload of the specified file}
\usage{
upload_init(
  token = NULL,
  project_id = NULL,
  name = NULL,
  size = NULL,
  part_size = NULL,
  ...
)
}
\arguments{
\item{token}{auth token}

\item{project_id}{ID of the project you wish to upload to}

\item{name}{Name of the file you wish to upload}

\item{size}{Size of the file you wish to upload}

\item{part_size}{Requested part size. Note that API may reject your
requested part size and return proper one in response.}

\item{...}{parameters passed to api function}
}
\value{
parsed list of the returned json
}
\description{
This is the first operation performed when you wish to upload a file.
Operation is initialized by providing file name, project id where you
wish the file to be uploaded to (if not specified, defaults to user's stash)
and optionally by providing wanted part size. You may wish to set your
part size to a low value if you experience problems with uploading large
file parts, although default value of 5MB should be good enough for
most users.
}
\details{
Limits: \itemize{
\item Maximum number of parts is 10000
\item Maximum file size is 5TB
\item Maximum part size is 5GB
\item Default part size is 5MB}
}
\examples{
token <- "your_token"
\dontrun{
req <- upload_init(
  token,
  project_id = "your_project_id",
  name = "Sample1_RNASeq_chr20.pe_1.fastq", size = 5242880
)}
}
