% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnv.R
\name{visualizeSegments}
\alias{visualizeSegments}
\title{Visualize segments}
\usage{
visualizeSegments(seg, to.plot = NULL, genes.to.label = NULL)
}
\arguments{
\item{seg}{a \code{CNSegment} object}

\item{to.plot}{chromosome to plot (by default plot all chromosomes)}

\item{genes.to.label}{gene(s) to label}
}
\value{
plot graphics
}
\description{
The function takes a \code{CNSegment} object obtained from cnSegmentation
and plot the bin signals and segments (as horizontal lines).
}
\details{
require ggplot2, scales
}
\examples{

sesameDataCache()
\dontrun{
sdfs <- sesameDataGet('EPICv2.8.SigDF')
sdf <- sdfs[["K562_206909630040_R01C01"]]
seg <- cnSegmentation(sdf)
seg <- cnSegmentation(sdf, return.probe.signals=TRUE)
visualizeSegments(seg)
visualizeSegments(seg, to.plot=c("chr9","chr22"))
visualizeSegments(seg, genes.to.label=c("ABL1","BCR"))
}

sesameDataGet_resetEnv()

}
