% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{imputeBetasMatrixByMean}
\alias{imputeBetasMatrixByMean}
\title{Impute Missing Values with Mean
This function replaces missing values (NA) in a matrix, default is row
means.}
\usage{
imputeBetasMatrixByMean(mx, axis = 1)
}
\arguments{
\item{mx}{A matrix}

\item{axis}{A single integer. Use 1 to impute column means (default),
and 2 to impute row means.}
}
\value{
A matrix with missing values imputed.
}
\description{
Impute Missing Values with Mean
This function replaces missing values (NA) in a matrix, default is row
means.
}
\examples{
mx <- cbind(c(1, 2, NA, 4), c(NA, 2, 3, 4))
imputeBetasMatrixByMean(mx, axis = 1)
imputeBetasMatrixByMean(mx, axis = 2)
}
