% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dye_bias.R
\name{dyeBiasNL}
\alias{dyeBiasNL}
\alias{dyeBiasCorrTypeINorm}
\title{Dye bias correction by matching green and red to mid point}
\usage{
dyeBiasNL(sdf, mask = TRUE, verbose = FALSE)

dyeBiasCorrTypeINorm(sdf, mask = TRUE, verbose = FALSE)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{mask}{include masked probes in Infinium-I probes. No big difference is
noted in practice. More probes are generally better.}

\item{verbose}{print more messages}
}
\value{
a \code{SigDF} after dye bias correction.
}
\description{
This function compares the Type-I Red probes and Type-I Grn probes and
generates and mapping to correct signal of the two channels to the middle.
The function takes one single \code{SigDF} and returns a \code{SigDF}
with dye bias corrected.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sdf.db <- dyeBiasNL(sdf)
sdf <- sesameDataGet('EPIC.1.SigDF')
sdf <- dyeBiasCorrTypeINorm(sdf)
}
