% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dye_bias.R
\name{dyeBiasCorrMostBalanced}
\alias{dyeBiasCorrMostBalanced}
\title{Correct dye bias using most balanced sample as the reference}
\usage{
dyeBiasCorrMostBalanced(sdfs)
}
\arguments{
\item{sdfs}{a list of normalized \code{SigDF}s}
}
\value{
a list of normalized \code{SigDF}s
}
\description{
The function chose the reference signal level from a list of \code{SigDF}.
The chosen sample has the smallest difference in Grn and Red signal
intensity as measured using the normalization control probes. In practice,
it doesn't matter which sample is chosen as long as the reference level
does not deviate much. The function returns a list of \code{SigDF}s with
dye bias corrected.
}
\examples{
sesameDataCache() # if not done yet
sdfs <- sesameDataGet('HM450.10.SigDF')[1:2]
sdfs.db <- dyeBiasCorrMostBalanced(sdfs)
}
