% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_profile.R
\name{read_profiles}
\alias{read_profiles}
\title{Read SNV profiles}
\usage{
read_profiles(profile_dir, pattern = ".profile.txt",
  sample_names = FALSE)
}
\arguments{
\item{profile_dir}{The directory containing the profiles to be read (path).}

\item{pattern}{Pattern for file name or extension to be read (character).}

\item{sample_names}{Add sample name based on file name; overrides profile
sample if it already exists (boolean).}
}
\value{
A list of data frames.
}
\description{
Read SNV profiles in a directory.
}
\details{
This is a wrapper function for reading multiple SNV profiles
 present in a directory (and its sub-directories in recursive mode).
}
\examples{
# Path to test data
profile_dir = system.file("extdata", package = "seqCAT")

# Read test profiles
profile_list <- read_profiles(profile_dir, pattern = "profile.txt")
}
