% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_variants.R
\name{filter_variants}
\alias{filter_variants}
\title{Variant filtering}
\usage{
filter_variants(data, min_depth = 10, filter_vc = FALSE,
  filter_mt = FALSE, filter_ns = FALSE)
}
\arguments{
\item{data}{The dataframe containing the variant data to be filtered.}

\item{min_depth}{Threshold for variant depth (integer).}

\item{filter_vc}{Filter variants not passing filtering criteria (boolean).}

\item{filter_mt}{Filter mitochondrial variants (boolean).}

\item{filter_ns}{Filter non-standard chromosomes (boolean).}
}
\value{
A data frame containing the filtered variants.
}
\description{
Filter variants on several criteria.
}
\details{
This is a function for filtering SNV profiles on several criteria:
sequencing depth, variant caller-specific filtering, mitochondrial variants
and variants in non-standard chromosomes. Only filters by sequencing depth
by default.
}
\examples{
# Load test comparisons
data(test_profile_1)

# Filter variants
filtered <- filter_variants(test_profile_1, min_depth = 15)
}
