% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_profiles.R
\name{compare_profiles}
\alias{compare_profiles}
\title{Binary SNV profile comparisons}
\usage{
compare_profiles(profile_1, profile_2, mode = "intersection")
}
\arguments{
\item{profile_1}{The first SNV profile (GRanges object).}

\item{profile_2}{The second SNV profile (GRanges object).}

\item{mode}{Merge profiles using "union" or "intersection" (character).}
}
\value{
A dataframe.
}
\description{
Overlap and compare genotypes in two SNV profiles.
}
\details{
This is a function for finding overlapping variants in two
different SNV profiles (stored as GenomicRanges objects), followed by
comparing the genotypes of the overlapping variants. The "compare_overlaps"
function calls the "add_metadata" function twice in succession in order to
merge the metadata for the two profiles (supplied as GRanges objects),
returns the results as a dataframe, compares the genotypes of the
overlapping variants using the "compare_genotypes" function and, finally,
returns the final dataframe with all variant overlaps and their similarity.
}
\examples{
# Load test data
data(test_profile_1)
data(test_profile_2)

# Compare the two profiles
comparison <- compare_profiles(test_profile_1, test_profile_2)
}
