% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{estim.nbinom}
\alias{estim.nbinom}
\alias{estim.zinb}
\title{Internal function}
\usage{
estim.nbinom(y, z, gamma)

estim.zinb(y, z, gamma)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}
}
\value{
These functions return a list of numerics.
}
\description{
These functions estimate the parameters of the
(zero-inflated) negative binomial distribution
by applying the maximum likelihood method
to the labelled observations in class 0.
}
\examples{
# data simulation
n <- 100
y <- stats::rnbinom(n=n,mu=5,size=1/0.05)
y[sample(1:n,size=0.2*n)] <- 0
z <- rep(0,times=n)
gamma <- rep(1,times=n)

# parameter estimation
estim.nbinom(y,z,gamma)
estim.zinb(y,z,gamma)

}
\seealso{
These are \code{\link{internal}} functions.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
