% modification on git from copied files
\name{alignmentMeth-class}
\Rdversion{1.1}
\docType{class}
\alias{alignmentMeth-class}
\alias{alignmentMeth}
\alias{[,alignmentMeth-method}
\alias{[,alignmentMeth,ANY,ANY,ANY-method}
\alias{[,alignmentMeth,ANY,ANY-method}
\alias{[,alignmentMeth,ANY-method}
\alias{dim,alignmentMeth-method}
\alias{initialize,alignmentMeth-method}
\alias{show,alignmentMeth-method}
\alias{cbind,alignmentMeth-method}

\title{Class "alignmentMeth"}
\description{The \code{alignmentMeth} class inherits from the
  \code{alignmentClass} class and records information about
  a set of alignments of high-throughput sequencing data to a
  genome. Details include the alignments themselves, the
  chromosomes of the genome to which the data are aligned, and
  counts of the aligned tags from each of the libraries from which the
  data come.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("alignmentMeth",
  ...)}, but more usually by using one of \code{\link{readBAM}} or
\code{\link{readGeneric}} functions to generate the object from a set of
alignment files.
}
\section{Slots}{
  \describe{
    \item{\code{alignments}:}{Object of class \code{"GRanges"}.
      Defines the location of sequenced cytosines, amongst other data. See Details.}
    \item{\code{libnames}:}{Object of class \code{"character"}. The
      names of the libraries for which alignment data exists.}
    \item{\code{replicates}:}{Object of class \code{"factor"}.
      Replicate information for each of the libraries. See Details.}
    \item{\code{Cs}:}{Object of class \code{"matrix"}. For each
      cytosine described in the \code{alignments} slot, contains the
      number of times the cytosine is sequenced as a 'C', and is thus
      methylated.}
    \item{\code{Ts}:}{Object of class \code{"matrix"}. For each
      cytosine described in the \code{alignments} slot, contains the
      number of times the cytosine is sequenced as a 'T', and is thus
      unmethylated.}    
    \item{\code{nonconversion}:}{Object of class \code{"numeric"}. The
      (estimated) nonconversion rate (see Details) for each of the libraries.}
  }
}

\section{Details}{
  The nonconversion slot is an estimate of the rate (for each library)
  at which an unmethylated cytosine has failed to be converted by sodium
  bisulphite treatment into thymine, and is thus recorded (incorrectly) as
  methylated. In some cases, this can be estimated from considering
  observed methylation rates on regions known to be unmethylated (e.g.,
  chloroplasts) or by introducing unmethylated control sequences.

  The \code{replicates} slot is a vector of factors such that the ith
  sample is a replicate of the jth sample if and only if \code{@replicates[i] ==
    @replicates[j]}.
}

\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "alignmentMeth")}: ... }
    \item{dim}{\code{signature(x = "alignmentMeth")}: ... }
    \item{initialize}{\code{signature(.Object = "alignmentMeth")}: ... }
    \item{show}{\code{signature(object = "alignmentMeth")}: ... }
	 }
}

\author{Thomas J. Hardcastle}

\seealso{
  \code{\link{alignmentClass}}, the class from which
  \code{'alignmentMeth'} inherits.
  \code{\link{readMeths}}, which will produce a \code{'alignmentMeth'}
  object from files generated by the YAMA aligner.
  \code{\link{processAD}}, which will convert an \code{'alignmentMeth'}
  object into a 'segData' object for segmentation.
}

\keyword{classes}

