% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citeseqApp.R
\name{exploreSubcl}
\alias{exploreSubcl}
\title{app to explore diversity in RNA-subclusters within ADT clusters}
\usage{
exploreSubcl(sce, inlist, adtcls)
}
\arguments{
\item{sce}{a SingleCellExperiment with altExp with ADT quantification}

\item{inlist}{list of SingleCellExperiments (SCEs) formed by scran::quickSubCluster}

\item{adtcls}{vector of ADT cluster assignments}
}
\value{
shinyApp instance
}
\description{
app to explore diversity in RNA-subclusters within ADT clusters
}
\note{
TSNE should already be available in `altExp(sce)`; follow OSCA book 12.5.2.  If using
example, set `ask=FALSE`.
}
\examples{
\donttest{
if (interactive()) {
sce <- getCh12Sce()
all.sce <- getCh12AllSce()
data(clusters.adt)
runApp(exploreSubcl(sce, all.sce, clusters.adt)) # trips up interactive pkgdown?)
}
}
}
