% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_fasta.R
\name{df_to_fasta}
\alias{df_to_fasta}
\title{Fasta file creation from dataframe columns and/or vectors.}
\usage{
df_to_fasta(
  sequence_name,
  sequence_strings,
  file_name = "sequences.fasta",
  output_dir = NULL,
  save_fasta = TRUE
)
}
\arguments{
\item{sequence_name}{Vector containing the names for each sequence, usually a column from a data.frame. eg. df$sequence_name}

\item{sequence_strings}{Vector containing the DNA or RNA or AA sequences, usually a column from a data.frame. eg. df$sequences}

\item{file_name}{Output file name to be saved as a fasta file}

\item{output_dir}{Output directory for the fasta file. Default is the working directory}

\item{save_fasta}{Logical argument, TRUE or FALSE, to indicate if fasta files should be saved. Default is TRUE.}
}
\value{
Saves a fasta file in the desired location, and also returns the stringset as BStringSet if saved as an object.
}
\description{
Creates a fasta file from vectors of names and sequences.
}
\examples{
## Example with vectors, default for save_fasta ir TRUE
df_to_fasta(
    sequence_name = c("myseq1", "myseq2"),
    sequence_strings = c("GATCGAT", "ATCGTAG"),
    file_name = "my_sequences.fasta",
    output_dir = "",
    save_fasta = FALSE
)
}
