% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDensity.R
\name{plotDensity}
\alias{plotDensity}
\title{Plot grid-based density.}
\usage{
plotDensity(spe, coi = NULL, probs = 0.5, reverseY = NULL, ...)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{coi}{A character vector of cell types of interest (COIs) to be plotted.
Default to all cell types.}

\item{probs}{Numeric value between 0 and 1, used for filtering
uninformative grid, default is 0.5.}

\item{reverseY}{Logical. Whether to reverse Y coordinates. Default is TRUE
if the spe contains an image (even if not plotted) and FALSE if otherwise.}

\item{...}{Parameters pass to \link[scider]{plotGrid}}
}
\value{
A ggplot object.
}
\description{
Plot grid-based density.
}
\examples{

data("xenium_bc_spe")

spe <- gridDensity(spe)

plotDensity(spe, coi = "Breast cancer")

plotDensity(spe, coi = "Fibroblasts")

}
