% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corDensity.R
\name{corDensity}
\alias{corDensity}
\title{Test for density correlation between two cell types.}
\usage{
corDensity(spe, coi = NULL, roi = NULL, probs = 0.85, trace = FALSE)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{coi}{Character vector for cell types of interest for density
correlation analysis. Default is NULL, which is to consider all cell types
previously calculated in the gridDensity() step.}

\item{roi}{Character. The name of the group or cell type on which
the roi is computed. Default is NULL for no subsetting cell types by ROI}

\item{probs}{A numeric scalar. The threshold of proportion that used to
filter grids by density when ROIs have not been identified previously.
Ignored if 'roi' is present in the 'metadata' component of spe. Default to 0.85.}

\item{trace}{Logical. If TRUE, print the process of testing. Default to FALSE.}
}
\value{
A DataFrame containing the testing results.
}
\description{
Test for density correlation between two cell types.
}
\examples{

data("xenium_bc_spe")

coi <- c("Breast cancer", "Fibroblasts", "B cells", "T cells")

spe <- gridDensity(spe, coi = coi)

spe <- findROI(spe, coi = coi, method = "walktrap")

result <- corDensity(spe, roi = coi)

}
