% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_meta.R
\name{plot_hexbin_meta}
\alias{plot_hexbin_meta}
\title{Plot of meta data of single cell data in bivariate hexagon cells.}
\usage{
plot_hexbin_meta(
  sce,
  col,
  action,
  no = 1,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{col}{A string referring to the name of one column in the meta data of
sce by which to colour the hexagons.}

\item{action}{A string specifying how meta data of observations in
binned  hexagon cells are to be summarized. Possible actions are
\code{majority}, \code{prop}, \code{prop_0}, \code{mode}, \code{mean} and
\code{median} (see details).}

\item{no}{An integer specifying which level to plot of the column. Only in
effect when \code{action=prop}.}

\item{colors}{A vector of strings specifying which colors to use for plotting
the different levels in the selected column of the meta data. Only in
effect when the selected \code{action="majority"}.}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}

\item{na.rm}{Logical indicating whether NA values should be removed.}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of meta data of single cell data in bivariate hexagon cells.
}
\details{
This function plots any column of the meta data in the hexagon cell
   representation calculated with \code{\link{make_hexbin}}. The chosen meta
   data column is summarized by one of six actions \code{majority},
   \code{prop}, \code{prop_0}, \code{mode}, \code{mean} and \code{median}:

   \describe{
      \item{\code{majority}}{Returns the value of the majority of
      observations in the bin. The associated meta data column needs to be
      a factor or character.}
      \item{\code{prop}}{Returns the proportion of each level or unique
      character in the bin. The associated meta data column needs to be
      a factor or character}
      \item{\code{prop_0}}{Returns the proportion of observations in the b
      factor or character in the bin
      greater than 0. The associated meta data column needs to be numeric.}
      \item{\code{mode}}{Returns the mode of the observations in the bin. The
      associated meta data column needs to be numeric.}
      \item{\code{mean}}{Returns the mean of the observations in the bin. The
      associated meta data column needs to be numeric.}
      \item{\code{median}}{Returns the median of the observations in the bin.
      The associated meta data column needs to be numeric.}
  }
}
\examples{
# For SingleCellExperiment object
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[-rm_ind, ]
colData(tenx_pbmc3k) <- cbind(
    colData(tenx_pbmc3k),
    perCellQCMetrics(tenx_pbmc3k)
)
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 20, dimension_reduction = "PCA")
plot_hexbin_meta(tenx_pbmc3k, col = "total", action = "median")
}
