% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.expression.prior}
\alias{scde.expression.prior}
\title{Estimate prior distribution for gene expression magnitudes}
\usage{
scde.expression.prior(models, counts, length.out = 400, show.plot = FALSE,
  pseudo.count = 1, bw = 0.1, max.quantile = 1 - 0.001,
  max.value = NULL)
}
\arguments{
\item{models}{models determined by \code{\link{scde.error.models}}}

\item{counts}{count matrix}

\item{length.out}{number of points (resolution) of the expression magnitude grid (default: 400). Note: larger numbers will linearly increase memory/CPU demands.}

\item{show.plot}{show the estimate posterior}

\item{pseudo.count}{pseudo-count value to use (default 1)}

\item{bw}{smoothing bandwidth to use in estimating the prior (default: 0.1)}

\item{max.quantile}{determine the maximum expression magnitude based on a quantile (default : 0.999)}

\item{max.value}{alternatively, specify the exact maximum expression magnitude value}
}
\value{
a structure describing expression magnitude grid ($x, on log10 scale) and prior ($y)
}
\description{
Use existing count data to determine a prior distribution of genes in the dataset
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
data(o.ifm)  # Load precomputed model. Use ?scde.error.models to see how o.ifm was generated
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)

}

