% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccomp_replicate.R
\name{sccomp_replicate}
\alias{sccomp_replicate}
\title{sccomp_replicate}
\usage{
sccomp_replicate(
  fit,
  formula_composition = NULL,
  formula_variability = NULL,
  number_of_draws = 1,
  mcmc_seed = sample_seed(),
  cache_stan_model = sccomp_stan_models_cache_dir
)
}
\arguments{
\item{fit}{The result of sccomp_estimate.}

\item{formula_composition}{A formula. The formula describing the model for differential abundance, for example ~treatment. This formula can be a sub-formula of your estimated model; in this case all other factor will be factored out.}

\item{formula_variability}{A formula. The formula describing the model for differential variability, for example ~treatment. In most cases, if differentially variability is of interest, the formula should only include the factor of interest as a large anount of data is needed to define variability depending to each factors. This formula can be a sub-formula of your estimated model; in this case all other factor will be factored out.}

\item{number_of_draws}{An integer. How may copies of the data you want to draw from the model joint posterior distribution.}

\item{mcmc_seed}{An integer. Used for Markov-chain Monte Carlo reproducibility. By default a random number is sampled from 1 to 999999. This itself can be controlled by set.seed()}

\item{cache_stan_model}{A character string specifying the cache directory for compiled Stan models.
The sccomp version will be automatically appended to ensure version isolation.
Default is \code{sccomp_stan_models_cache_dir} which points to \verb{~/.sccomp_models}.}
}
\value{
A tibble \code{tbl} with cell_group-wise statistics

A tibble (\code{tbl}), with the following columns:
\itemize{
\item \strong{cell_group} - A character column representing the cell group being tested.
\item \strong{sample} - A factor column representing the sample name from which data was generated.
\item \strong{generated_proportions} - A numeric column representing the proportions generated from the model.
\item \strong{generated_counts} - An integer column representing the counts generated from the model.
\item \strong{replicate} - An integer column representing the replicate number, where each row corresponds to a different replicate of the data.
}
}
\description{
This function replicates counts from a real-world dataset.
}
\examples{

print("cmdstanr is needed to run this example.")
# Note: Before running the example, ensure that the 'cmdstanr' package is installed:
# install.packages("cmdstanr", repos = c("https://stan-dev.r-universe.dev/", getOption("repos")))

\donttest{
  if (instantiate::stan_cmdstan_exists() && .Platform$OS.type == "unix") {
    data("counts_obj")

    sccomp_estimate(
      counts_obj,
      ~ type, ~1, "sample", "cell_group", "count",
      cores = 1
    ) |>
    sccomp_replicate()
  }
}
}
\references{
S. Mangiola, A.J. Roth-Schulze, M. Trussart, E. Zozaya-Valdés, M. Ma, Z. Gao, A.F. Rubin, T.P. Speed, H. Shim, & A.T. Papenfuss, sccomp: Robust differential composition and variability analysis for single-cell data, Proc. Natl. Acad. Sci. U.S.A. 120 (33) e2203828120, https://doi.org/10.1073/pnas.2203828120 (2023).
}
