\name{cellCellRanks}
\docType{methods}
\alias{cellCellRanks,SingleCellExperiment-method}
\alias{cellCellRanks}

\title{
Rank estimation of the CCI-tensor
}
\description{
SVD is performed in each mode.
}
\usage{
cellCellRanks(sce, centering=TRUE,
    mergeas=c("mean", "sum"), outerfunc=c("*", "+"), comb=c("random", "all"),
    num.sampling=100, num.perm=1000, assayNames = "counts", verbose=FALSE,
    num.iter1=5, num.iter2=5, num.iter3=NULL)
}

\arguments{
\item{sce}{
A object generated by instantization of SingleCellExperiment-class.
}
\item{centering}{
When the value is TRUE, input matrix is summarized as celltype-level vectors
(Default: TRUE).
}
\item{mergeas}{
When the centering is TRUE, "mean" (celltype-level mean vector)
or "sum" (celltype-level sum vector) is calculated (Default: "mean").
}
\item{outerfunc}{
When the centering is TRUE, "*" (Kronecker product) or "+" (Kronecker sum) or is calculated (Default: "+").
}
\item{comb}{
When the centering is FALSE, "random" (random cell-cell pairing)
or "all" (all possible cell-cell pairing) is calculed (Default: "random").
}
\item{num.sampling}{
The number of random sampling used (Default: 100).
}
\item{num.perm}{
The number of the permutation in label permutation test (Default: 1000).
}
\item{assayNames}{
The unit of gene expression for using scTensor (e.g. normcounts, cpm...etc) (Default: "counts").
}
\item{verbose}{
The verbose parameter for nnTensor::NTD (Default: FALSE).
}
\item{num.iter1}{
The number of iteration to estimate the rank of mode-1 matricised data tensor (Default: 5).
}
\item{num.iter2}{
The number of iteration to estimate the rank of mode-2 matricised data tensor (Default: 5).
}
\item{num.iter3}{
The number of iteration to estimate the rank of mode-3 matricised data tensor (Default: NULL).
}
}

\value{
RSS: A list with three elements, in which each element means the average reconstructed error in each rank.
selected: A vector with three elements, in which each element means the estimated ranks in mode-1, 2 and 3 matricization.
}
\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}

\author{Koki Tsuyuzaki}

\examples{
showMethods("cellCellRanks")
}

\keyword{methods}