\name{cellCellDecomp}
\docType{methods}
\alias{cellCellDecomp,SingleCellExperiment-method}
\alias{cellCellDecomp}

\title{
Performing scTensor
}
\description{
All parameters is saved to metadata slot of SingleCellExperiment object.
}
\usage{
cellCellDecomp(sce, algorithm=c("ntd2", "ntd", "nmf", "cx", "pearson",
    "spearman", "distance", "pearson.lr", "spearman.lr", "distance.lr",
    "pcomb", "label.permutation", "cabello.aguilar", "halpern"), ranks=c(3,3), rank=3, thr1=log2(5), thr2=25, thr3=0.95, L1_A=0, L2_A=0, verbose=FALSE,
    centering=TRUE, mergeas=c("mean", "sum"), outerfunc=c("*", "+"),
    comb=c("random", "all"), num.sampling=100, num.perm=1000, assayNames = "counts", decomp=TRUE)
}

\arguments{
\item{sce}{
The object generated by instantization of SingleCellExperiment-class.
}
\item{algorithm}{
Algorithm for constrcting cell-cell similarity matrix.
"ntd2", "ntd", "nmf", "cx", "pearson", "spearman", "distance",
"pearson.lr", "spearman.lr", "distance.lr", "pcomb" or "label.permutation"
can be specified (Default: ntd2).
}
\item{ranks}{
The size of the core tensor decomposed by NTD.
Each element means (Number of Ligand-Cell Pattern,
Number of Receptor-Cell Pattern, Number of LR-pairs Pattern)
(Default: c(3,3)).
}
\item{rank}{
The number of low dimension of NMF (Default: 3).
}
\item{thr1}{
The threshold used by pcomb (Default: log2(5)).
}
\item{thr2}{
The threshold used by pcomb (Default: 25).
}
\item{thr3}{
The threshold used by cx (Default: 0.95).
}
\item{L1_A}{
The parameter to control the sparseness (Default: 0).
}
\item{L2_A}{
The parameter to control the outlier (Default: 0).
}
\item{verbose}{
The verbose parameter for nnTensor::NTD (Default: FALSE).
}
\item{centering}{
When the value is TRUE, input matrix is summarized as celltype-level vectors
(Default: TRUE).
}
\item{mergeas}{
When the centering is TRUE, "sum" (celltype-level sum vector)
or "mean" (celltype-level average vector) is calculated (Default: "sum").
}
\item{outerfunc}{
When the centering is TRUE, "+" (Kronecker sum) or "*" (Kronecker product)
is calculated (Default: "+").
}
\item{comb}{
When the centering is FALSE, "random" (random cell-cell pairing)
or "all" (all possible cell-cell pairing) is calculed (Default: "random").
}
\item{num.sampling}{
The number of random sampling used (Default: 100).
}
\item{num.perm}{
The number of the permutation in label permutation test (Default: 1000).
}
\item{assayNames}{
The unit of gene expression for using scTensor (e.g. normcounts, cpm...etc) (Default: "counts").
}
\item{decomp}{
When the value is TRUE, cell-cell interaction tensor is decomposed
(Default: TRUE).
}
}

\value{
The result is saved to metadata slot of SingleCellExperiment object.
}
\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}

\author{Koki Tsuyuzaki}

\examples{
showMethods("cellCellDecomp")
}

\keyword{methods}