% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTHI_plotCluster.R
\name{scTHI_plotCluster}
\alias{scTHI_plotCluster}
\title{scTHI_plotCluster}
\usage{
scTHI_plotCluster(scTHIresult, cexPoint = 0.8, legendPos = c("topleft",
  "topright", "bottomright", "bottomleft"))
}
\arguments{
\item{scTHIresult}{scTHI object.}

\item{cexPoint}{Set the point size.}

\item{legendPos}{Character string to custom the legend position.}
}
\value{
None
}
\description{
Graphs the output of scTHI_runTsne, labeling cells by clusters.
}
\examples{
library(scTHI.data)
data(scExample)
result <-  scTHI_score(scExample,
                       cellCusterA = colnames(scExample)[1:30],
                       cellCusterB = colnames(scExample)[31:100],
                       cellCusterAName = "ClusterA",
                       cellCusterBName = "ClusterB", filterCutoff = 0,
                       pvalueCutoff = 1, nPermu = 100, ncore = 8)
result <- scTHI_runTsne(result)
scTHI_plotCluster(result)
}
