% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estDropoutNum.R
\name{estDropoutNum}
\alias{estDropoutNum}
\title{estDropoutNum: Estimate dropout gene number in a cell}
\usage{
estDropoutNum(sample = NULL, depth = 20, histCounts = NULL,
  return = "dropoutNum")
}
\arguments{
\item{sample}{A cell's raw read counts for each gene, could be a vector or a SingleCellExperiment object.}

\item{depth}{Relative sequencing depth to be predicted compared with initial sample depth, should between 0-100, default is 20.}

\item{histCounts}{Optional. Only needed when \code{sample} is blank or \code{sample = NULL}. A histogram table of raw read counts for the cell.}

\item{return}{A character for choosing the return value type of the function. "dropoutNum" (default) for dropout gene number, "geneNumPredict" for all expressed gene number predicted, "transcriptNum" for all transcript number predicted.}
}
\value{
The dropout gene number (or all expressed gene number) predicted in a cell.
}
\description{
This function is used to estimate dropout gene number in a cell for single-cell RNA-seq (scRNA-seq) data. It takes a non-negative vector of scRNA-seq raw read counts of a cell as input.
}
\examples{
# Load test data
data(scRecoverTest)

# Estimate dropout gene number in a cell
estDropoutNum(sample = counts[,1], return = "dropoutNum")

# Estimate all expressed gene number in a cell
estDropoutNum(sample = counts[,1], return = "geneNumPredict")


}
\seealso{
\code{\link{scRecover}}, for imputation of single-cell RNA-seq data.

\code{\link{countsSampling}}, for downsampling the read counts in a cell.

\code{\link{normalization}}, for normalization of single-cell RNA-seq data.

\code{\link{scRecoverTest}}, a test dataset for scRecover.
}
\author{
Zhun Miao.
}
