% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiAdaSampling.R
\name{multiAdaSampling}
\alias{multiAdaSampling}
\title{multi Adaptive Sampling function}
\usage{
multiAdaSampling(
  data,
  label,
  reducedDimName = NULL,
  classifier = "svm",
  percent = 1,
  L = 10,
  prob = FALSE,
  balance = TRUE,
  iter = 3
)
}
\arguments{
\item{data}{A dimension reduced matrix from \code{matPCs}.}

\item{label}{A named vector of label information for each sample.
The names should match the sample names of \code{data}}

\item{reducedDimName}{A name of the \code{reducedDim} to use. This must be
specified if \code{data} is a SingleCellExperiment object.}

\item{classifier}{Base classifier model, either  "SVM" (\code{svm}) or "RF"
\code{'rf'} is supported.}

\item{percent}{Percentage of samples to select at each iteration.}

\item{L}{Number of ensembles. Default to 10.}

\item{prob}{logical flag to return sample's probabilities to each class.}

\item{balance}{logical flag to if the cell types are balanced.
If \code{FALSE}, down sample large cell types classes to the median of all class
sizes.}

\item{iter}{A number of iterations to perform adaSampling.}
}
\value{
A final prediction, probabilities for each cell type and the model
are returned as a list.
}
\description{
Performs multiple adaptive sampling to train a classifier model.
}
\examples{

library(SingleCellExperiment)

# Loading the data
data("gse87795_subset_sce")

mat.expr <- gse87795_subset_sce
cellTypes <- gse87795_subset_sce$cellTypes

# Get dimension reduced matrix. We are using `logNorm` assay from `mat.expr`.
reducedDim(mat.expr, "matPCs") <- matPCs(mat.expr, assay = "logNorm")

# Here we are using Support Vector Machine as a base classifier.
result <- multiAdaSampling(mat.expr, cellTypes, reducedDimName = "matPCs", 
classifier = "svm", percent = 1, L = 10)
}
\author{
Pengyi Yang, Taiyun Kim
}
