% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{set_raw_data}
\alias{set_raw_data}
\alias{set_raw_data,eQTLObject-method}
\title{Set raw data in an eQTLObject.}
\usage{
set_raw_data(x, value, name)

\S4method{set_raw_data}{eQTLObject}(x, value, name)
}
\arguments{
\item{x}{An \code{eQTLObject}.}

\item{value}{The raw data.}

\item{name}{A character string indicating the key under which the matrix is
stored in \code{rawData}.}
}
\value{
eQTLObject.

An updated \code{eQTLObject}.
}
\description{
Set raw data in an eQTLObject.

Method to set eQTLObject raw data.
}
\examples{
  data(EQTL_obj)
  data123 <- matrix(0, nrow = 3, ncol = 3)
  set_raw_data(EQTL_obj, data123, "rawExpMat")

  data(EQTL_obj)
  data123 <- matrix(0, nrow = 3, ncol = 3)
  set_raw_data(EQTL_obj, data123, "rawExpMat")

}
