% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_matrix.R
\name{process_matrix}
\alias{process_matrix}
\title{Process a matrix to extract a row and convert it to a data frame.}
\usage{
process_matrix(id, matrix, name)
}
\arguments{
\item{id}{Character string specifying the row name to extract from the
matrix.}

\item{matrix}{A matrix from which the row will be extracted.}

\item{name}{Character string specifying the column name for the extracted
values.}
}
\value{
A data frame containing the extracted row and a column with the
row names.
}
\description{
Process a matrix to extract a row and convert it to a data frame.
}
\examples{
rownames <- c("CNN2", "TIGD2", "DTD2")
colnames <- c("Col1", "Col2", "Col3", "Col4")
matrix_data <- matrix(1:12, nrow = 3, ncol = 4,
  dimnames = list(rownames, colnames))
geneid <- "CNN2"
gene_mat <- process_matrix(geneid, matrix_data, "gene_mat")
}
