% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callQTL.R
\name{callQTL}
\alias{callQTL}
\title{Identify single-cell eQTLs.}
\usage{
callQTL(
  eQTLObject,
  gene_ids = NULL,
  downstream = NULL,
  upstream = NULL,
  gene_mart = NULL,
  snp_mart = NULL,
  pAdjustMethod = "bonferroni",
  useModel = "zinb",
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.1
)
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject}.}

\item{gene_ids}{A gene ID or a list of gene IDS.}

\item{downstream}{Distance (in base pairs) downstream of the gene start
site to search for associated SNPs.}

\item{upstream}{Distance (in base pairs) upstream of the gene end site to
search for associated SNPs.}

\item{gene_mart}{A Mart object representing the BioMart gene database.
If \code{NULL}, the Ensembl Gene BioMart will be used.}

\item{snp_mart}{A Mart object representing the BioMart SNP database.
If \code{NULL}, the Ensembl SNP BioMart will be used.}

\item{pAdjustMethod}{Method used for multiple testing correction. One of
\code{"bonferroni"}, \code{"holm"}, \code{"hochberg"}, \code{"hommel"}, or
\code{"BH"}. Default is \code{"bonferroni"}.}

\item{useModel}{Model used for fitting. One of "poisson", "zinb", or
"linear."}

\item{pAdjustThreshold}{Only SNP–gene pairs with adjusted p-values below
the threshold will be retained. Default is 0.05.}

\item{logfcThreshold}{The minimum beta coefficient required to report a
SNP–gene pair as an eQTL.}
}
\value{
A data frame in which each row corresponds to a detected SNP–gene
eQTL pair, including statistical and model fitting results.
}
\description{
This function detects eQTLs using scRNA-seq data and genotype data.
}
\examples{
data(EQTL_obj)
library(biomaRt)
gene_mart <- useEnsembl(biomart = "genes",
                        dataset = "hsapiens_gene_ensembl",
                        mirror = 'asia')
snp_mart <- useEnsembl(biomart = "snps",
                        dataset = "hsapiens_snp",
                        mirror = 'asia')
eqtl <- callQTL(
  eQTLObject = EQTL_obj,
  gene_ids = NULL,
  downstream = NULL,
  upstream = NULL,
  gene_mart = gene_mart,
  snp_mart = snp_mart,
  pAdjustMethod = 'bonferroni',
  useModel = 'linear',
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.025
)
}
