% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{plot_UMI_dup}
\alias{plot_UMI_dup}
\title{Plot UMI duplication frequency}
\usage{
plot_UMI_dup(sce, log10_x = TRUE)
}
\arguments{
\item{sce}{a \code{SingleCellExperiment} object}

\item{log10_x}{whether to use log10 scale for x axis}
}
\value{
a line chart of the UMI duplication frequency
}
\description{
Plot the UMI duplication frequency.
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

plot_UMI_dup(sce)

}
