% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safeColScale.R
\name{safeColScale}
\alias{safeColScale}
\title{Safe Centering and Scaling of Columns}
\usage{
safeColScale(
  X,
  center = TRUE,
  scale = TRUE,
  tol = .Machine$double.eps,
  eps = 0.01,
  scaled_matrix = FALSE
)
}
\arguments{
\item{X}{An input \code{matrix} to be centered and/or scaled. If \code{X} is
not of class \code{matrix} or \code{DelayedMatrix}, then it must be
coercible to a \code{matrix}.}

\item{center}{A \code{logical} indicating whether to re-center the columns
of the input \code{X}.}

\item{scale}{A \code{logical} indicating whether to re-scale the columns of
the input \code{X}.}

\item{tol}{A tolerance level for the lowest column variance (or standard
deviation) value to be tolerated when scaling is desired. The default is
set to \code{double.eps} of machine precision \code{.Machine}.}

\item{eps}{The desired lower bound of the estimated variance for a given
column. When the lowest estimate falls below \code{tol}, it is truncated
to the value specified in this argument. The default is 0.01.}

\item{scaled_matrix}{A \code{logical} indicating whether to output a
\code{\link[ScaledMatrix]{ScaledMatrix}} object. The centering and scaling
procedure is delayed until later, permitting more efficient matrix
multiplication and row or column sums downstream. However, this comes at the
at the cost of numerical precision. Defaults to \code{FALSE}.}
}
\value{
A centered and/or scaled version of the input data.
}
\description{
\code{safeColScale} is a safe utility for centering and scaling
 an input matrix \code{X}. It is intended to avoid the drawback of using
 \code{\link[base]{scale}} on data with constant variance by inducing adding
 a small perturbation to truncate the values in such columns. It also takes
 the opportunity to be faster than \code{\link[base]{scale}} through relying
 on \pkg{matrixStats} or \pkg{DelayedMatrixStats}, depending on the type of
 matrix being processed, for a key internal computation.
}
\keyword{internal}
