% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{open_h5_file}
\alias{open_h5_file}
\title{Open H5 file}
\usage{
open_h5_file(h5_file)
}
\arguments{
\item{h5_file}{a string of the h5 file directory}
}
\value{
a mtmutObj object
}
\description{
This function opens the H5 file and create a mtmutObj object.
}
\details{
The mtmutObj object is a S3 class for handling mitochondrial mutation data.
It contains the following elements:
\describe{
\item{file}{a string of the h5 file directory.}
\item{h5f}{H5 file handle.}
\item{mut_table}{allele count table H5 group handle.}
\item{loc_list}{list of available loci.}
\item{loc_selected}{selected loci, the default is all loci.}
\item{cell_list}{list of available cell ids.}
\item{cell_selected}{selected cell ids, the default is all cells.}
\item{loc_pass}{loci passed the filter, the default is NULL}
\item{loc_filter}{filter parameters.}
\item{loc_filter$min_cell}{a integer of the minimum number of cells with mutation, the default is 1.}
\item{loc_filter$model}{a string of the model for mutation calling, it can be "bb", "bm" or "bi", the default is "bb".}
\item{loc_filter$p_threshold}{a numeric of the p-value threshold, the default is 0.05.}
\item{loc_filter$p_adj_method}{a string of the method for p-value adjustment, refer to \code{\link[stats]{p.adjust}}, the default is "fdr".}
}
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")
## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")
## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)
f_h5
## open the h5 file and create a mtmutObj object
x <- open_h5_file(f_h5)
x
}
