% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{scHOT_calculateGlobalHigherOrderFunction}
\alias{scHOT_calculateGlobalHigherOrderFunction}
\title{scHOT_calculateGlobalHigherOrderFunction}
\usage{
scHOT_calculateGlobalHigherOrderFunction(
  scHOT,
  higherOrderFunction = NULL,
  higherOrderFunctionType = NULL
)
}
\arguments{
\item{scHOT}{A scHOT object}

\item{higherOrderFunction}{A function object indicating the higher order function}

\item{higherOrderFunctionType}{is "weighted" or "unweighted", determines if there
is a weighting argument in the higher order function}
}
\value{
A scHOT object with scHOT_output$globalHigherOrderFunction in
slot scHOT_output saved
}
\description{
this calculates the global higher order function
and stores it in the output
if these aren't found in the params slot
then they need to be specified here
}
\details{
Calculates the global higher order function
}
\examples{

 data(MOB_subset)
 sce_MOB_subset <- MOB_subset$sce_MOB_subset
 scHOT_spatial <- scHOT_buildFromSCE(sce_MOB_subset,
                                     assayName = "logcounts",
                                    positionType = "spatial",
                                     positionColData = c("x", "y"))
pairs <- matrix(c("Arrb1", "Mtor", "Dnm1l", "Gucy1b3"), ncol = 2, byrow = TRUE)
rownames(pairs) <- apply(pairs,1,paste0,collapse = "_")
scHOT_spatial <- scHOT_addTestingScaffold(scHOT_spatial, pairs)
 scHOT_spatial <- scHOT_setWeightMatrix(scHOT_spatial,
                                       positionColData = c("x","y"),
                                        positionType = "spatial",
                                        nrow.out = NULL,
                                        span = 0.05)
scHOT_spatial <- scHOT_calculateGlobalHigherOrderFunction(
  scHOT_spatial,
  higherOrderFunction = weightedSpearman,
  higherOrderFunctionType = "weighted")

}
