% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scgps_object.R
\name{new_summarized_scGPS_object}
\alias{new_summarized_scGPS_object}
\title{new_summarized_scGPS_object}
\usage{
new_summarized_scGPS_object(
  ExpressionMatrix = NULL,
  GeneMetadata = NULL,
  CellMetadata = NULL
)
}
\arguments{
\item{ExpressionMatrix}{An expression dataset in matrix format.
Rows should represent a transcript and its normalised counts,
while columns should represent individual cells.}

\item{GeneMetadata}{A data frame or vector containing gene identifiers used 
in the expression matrix. The first column should hold the cell identifiers
you are using in the expression matrix. Other columns contain information 
about the genes, such as their corresponding ENSEMBL transcript identifiers.}

\item{CellMetadata}{A data frame containing cell identifiers 
(usually barcodes) and clustering information (the first column of the data
frame contains clustering information). The column containing clustering
information needs to be named as 'Cluster'. If clustering information is not
available, users can run CORE function and add the information to the scGPS
before running scGPS prediction}
}
\value{
This function generates an scGPS object belonging to the
\linkS4class{SingleCellExperiment}.
}
\description{
\code{\link{new_scGPS_object}} generates a scGPS object in the 
\linkS4class{SingleCellExperiment} class for use with the scGPS package. This
object contains an expression matrix, associated metadata (cells, genes,
clusters). The data are expected to be normalised counts.
}
\examples{
day2 <- day_2_cardio_cell_sample
t <-new_summarized_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
colData(t); show(t); colnames(t)
}
\seealso{
\linkS4class{SingleCellExperiment}
}
\author{
Quan Nguyen, 2017-11-25
}
