% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regressPCObject.R
\name{plotVarianceContribution}
\alias{plotVarianceContribution}
\title{Generate Variance Contribution Bar Plot with Component Breakdown}
\usage{
plotVarianceContribution(x, ...)
}
\arguments{
\item{x}{An object of class \code{regressPCObject} containing regression results
from \code{regressPC} function.}

\item{...}{Additional arguments passed to the plotting function (currently unused).}
}
\value{
A \code{ggplot2} object representing the variance contribution bar plot
  with optional component breakdown.
}
\description{
Creates a bar plot visualization of variance contributions for each principal component,
showing how much total dataset variance is explained by the regression model.
When available, displays stacked bars showing individual component contributions
(cell type, batch/dataset, and interaction effects).
}
\details{
This function visualizes the variance contribution of each principal component,
calculated as the product of PC variance and R-squared values. The variance
contribution represents the percentage of total dataset variance explained by
the regression model for each PC.

When component decomposition is available, the function creates stacked bars with:
\itemize{
  \item Cell type main effect contribution (blue)
  \item Batch or dataset main effect contribution (orange)
  \item Interaction effect contribution (green)
}

The plot subtitle includes the total variance explained across all principal
components. PC labels show the individual variance percentage for each component.
The function automatically selects appropriate PCA variance values based on
analysis type (query-only vs. query+reference).
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
