% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotDoubletMap}
\alias{plotDoubletMap}
\title{plotDoubletMap}
\usage{
plotDoubletMap(
  sce,
  colorBy = "enrichment",
  labelBy = "observed",
  addSizes = TRUE,
  col = NULL,
  column_title = "Clusters",
  row_title = "Clusters",
  column_title_side = "bottom",
  na_col = "white",
  ...
)
}
\arguments{
\item{sce}{A SingleCellExperiment object on which `scDblFinder` has been run
with the cluster-based approach.}

\item{colorBy}{Determines the color mapping. Either "enrichment" (for
log2-enrichment over expectation) or any column of
`metadata(sce)$scDblFinder.stats`}

\item{labelBy}{Determines the cell labels. Either "enrichment" (for
log2-enrichment over expectation) or any column of
 `metadata(sce)$scDblFinder.stats`}

\item{addSizes}{Logical; whether to add the sizes of clusters to labels}

\item{col}{The colors scale to use (passed to `ComplexHeatmap::Heatmap`)}

\item{column_title}{passed to `ComplexHeatmap::Heatmap`}

\item{row_title}{passed to `ComplexHeatmap::Heatmap`}

\item{column_title_side}{passed to `ComplexHeatmap::Heatmap`}

\item{na_col}{color for NA cells}

\item{...}{passed to `ComplexHeatmap::Heatmap`}
}
\value{
a Heatmap object
}
\description{
Plots a heatmap of observed versus expected doublets.
Requires the `ComplexHeatmap` package.
}
